{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.01.99 - 11:44:48 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Menus,
  StdCtrls,
  MMObj,
  MMAbout,
  MMAVI,
  MMDIB, ExtCtrls;

type
  TMainForm = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Openlist1: TMenuItem;
    SaveItem: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    ListBox1: TListBox;
    AddItem: TMenuItem;
    OpenDialog2: TOpenDialog;
    SaveDialog2: TSaveDialog;
    SaveListItem: TMenuItem;
    AVICompressor: TMMAVICompressor;
    AVIFile: TMMAVIFile;
    procedure About1Click(Sender: TObject);
    procedure Openlist1Click(Sender: TObject);
    procedure SaveItemClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure AddItemClick(Sender: TObject);
    procedure SaveListItemClick(Sender: TObject);
  private
    procedure UpdateEnable;
    procedure SaveAVI(const FName: string);
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
    UpdateEnable;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
    Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.UpdateEnable;
begin
    SaveItem.Enabled := ListBox1.Items.Count > 0;
    SaveListItem.Enabled := SaveItem.Enabled;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.OpenList1Click(Sender: TObject);
begin
    if OpenDialog1.Execute then
    try
       try
          ListBox1.Items.LoadFromFile(OpenDialog1.FileName);
       except
          ListBox1.Clear;
          raise;
       end;

    finally
       UpdateEnable;
    end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SaveItemClick(Sender: TObject);
begin
    if SaveDialog1.Execute then
        SaveAVI(SaveDialog1.FileName);
end;

{-- TMainForm -----------------------------------------------------------------}
{ TODO: Make independent from screen colors }
function UniformDIB(src: PDIB): PDIB;
var
    hbm: HBitmap;
    pal: HPalette;
begin
    Result := nil;

    if src = nil then exit;

    DIB_DIBToBitmap(src,hbm,pal);
    try
       if hbm <> 0 then
          Result := DIB_BitmapToDIB(hbm,0,24,1);
    finally
        if hbm <> 0 then
            DeleteObject(hbm);
        if pal <> 0 then
            DeleteObject(pal);
    end;
    if Result = nil then
        raise Exception.Create('Error during uniforming');
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SaveAVI(const FName: string);
var
    i   : Integer;
    pd  : PDIB;
    pud : PDIB;
    Save: TCursor;
    VideoWorker: TMMAVIVideoWorker;
    AVIStream: TMMAVIStream;
    HasFormat: Boolean;
begin
    Save := Screen.Cursor;
    Screen.Cursor := crHourglass;
    try
        AVIFile.FileName := FName;
        { create a new AVI file }
        AVIFile.CreateFile;
        try
            { create a new video stream in the AVI file }
            AVIStream := AVIFile.CreateVideoStream(1,'My Video Stream');
            try
               { add the stream to the compressor so we can choose the format }
               AVICompressor.AddStream(AVIStream);
               try
                  HasFormat := False;

                  { choose the compressed format }
                  if AVICompressor.LoadOptionsFromRegistry(HKEY_CURRENT_USER, 'Software\SwiftSoft','AVIOptions') then
                     HasFormat := True
                  else if AVICompressor.ChooseOptions then
                        HasFormat := True;

                  if HasFormat then
                  begin
                     { create a "Video Worker" which does the compression }
                     VideoWorker := TMMAVIVideoWorker.CreateCompressed(AVIStream,AVICompressor.Options[0]);
                     try
                        { now go trough the list and put all DIB's to the AVI }
                        for i := 0 to ListBox1.Items.Count - 1 do
                        begin
                           { load a Bitmap file }
                           pd := DIB_OpenFile(PChar(ListBox1.Items[i]));
                           try
                              { adjust the DIB format }
                              pud := UniformDIB(pd);
                              try
                                 { now put it to the AVI stream }
                                 if (pud <> nil) then
                                    VideoWorker.DIB[i] := pud;
                              finally
                                 if (pud <> nil) then
                                     GlobalFreePtr(pud);
                              end;

                           finally
                              if (pd <> nil) then
                                 GlobalFreePtr(pd);
                           end;
                        end;

                     finally
                        { free the "Video Worker" }
                        VideoWorker.Free;
                     end;
                  end;

               finally
                  if HasFormat then
                     AVICompressor.SaveOptionsToRegistry(HKEY_CURRENT_USER, 'Software\SwiftSoft','AVIOptions');

                  { remove all references to our stream so we can release it }
                  AVICompressor.FreeStreams;
               end;

            finally
               { release the stream, don't use Free, we use a reference counter internal }
               AVIStream.Release;
            end;

        finally
            { finaly close the file }
            AVIFile.CloseFile;
        end;

    finally
        Screen.Cursor := Save;
    end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
    if Key = VK_INSERT then
        AddItem.Click
    else
        Exit;
    Key := 0;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.AddItemClick(Sender: TObject);
begin
    if OpenDialog2.Execute then
    begin
        if OpenDialog2.Files.Count > 1 then
            ListBox1.Items.AddStrings(OpenDialog2.Files)
        else
            ListBox1.Items.Add(OpenDialog2.FileName);
        UpdateEnable;
    end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SaveListItemClick(Sender: TObject);
begin
    if SaveDialog2.Execute then
        ListBox1.Items.SaveToFile(SaveDialog2.FileName);
end;

{-- TMainForm -----------------------------------------------------------------}
end.
